VERSION 5.00
Begin VB.Form frmLoadIcon32Bit 
   Appearance      =   0  'Flat
   AutoRedraw      =   -1  'True
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "A demo of loading 32-bit icon"
   ClientHeight    =   7725
   ClientLeft      =   1290
   ClientTop       =   2415
   ClientWidth     =   7125
   Icon            =   "LoadIcon32Bit.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   NegotiateMenus  =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   515
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   475
   Begin VB.CommandButton cmdAlpha 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Show Alpha Effects"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   465
      Left            =   3690
      TabIndex        =   11
      Top             =   6750
      Width           =   2475
   End
   Begin VB.PictureBox picMask 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      BackColor       =   &H80000005&
      BorderStyle     =   0  'None
      FillStyle       =   0  'Solid
      ForeColor       =   &H80000008&
      Height          =   495
      Left            =   2640
      ScaleHeight     =   33
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   37
      TabIndex        =   8
      Top             =   240
      Width           =   555
   End
   Begin VB.PictureBox picImage 
      AutoRedraw      =   -1  'True
      BackColor       =   &H80000008&
      BorderStyle     =   0  'None
      FillStyle       =   0  'Solid
      Height          =   585
      Left            =   1440
      ScaleHeight     =   39
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   39
      TabIndex        =   6
      Top             =   2190
      Visible         =   0   'False
      Width           =   585
   End
   Begin VB.PictureBox PicIcon 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   0  'None
      FillStyle       =   0  'Solid
      ForeColor       =   &H80000008&
      Height          =   510
      Left            =   3930
      ScaleHeight     =   34
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   34
      TabIndex        =   5
      Top             =   240
      Width           =   510
   End
   Begin VB.PictureBox PicGrid 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      BackColor       =   &H80000005&
      ForeColor       =   &H00808080&
      Height          =   4065
      Left            =   1380
      ScaleHeight     =   269
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   275
      TabIndex        =   3
      Top             =   1980
      Visible         =   0   'False
      Width           =   4155
      Begin VB.PictureBox picTemp 
         Appearance      =   0  'Flat
         AutoRedraw      =   -1  'True
         BackColor       =   &H00C0C0C0&
         BorderStyle     =   0  'None
         FillStyle       =   0  'Solid
         ForeColor       =   &H80000008&
         Height          =   510
         Index           =   1
         Left            =   450
         ScaleHeight     =   34
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   34
         TabIndex        =   13
         Top             =   1350
         Visible         =   0   'False
         Width           =   510
      End
      Begin VB.PictureBox picTemp 
         Appearance      =   0  'Flat
         AutoRedraw      =   -1  'True
         BackColor       =   &H00C0C0C0&
         BorderStyle     =   0  'None
         FillStyle       =   0  'Solid
         ForeColor       =   &H80000008&
         Height          =   510
         Index           =   0
         Left            =   300
         ScaleHeight     =   34
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   34
         TabIndex        =   12
         Top             =   990
         Visible         =   0   'False
         Width           =   510
      End
   End
   Begin VB.PictureBox picDispContainer 
      BackColor       =   &H00E0E0E0&
      Height          =   5535
      Left            =   750
      ScaleHeight     =   365
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   357
      TabIndex        =   0
      Top             =   1020
      Width           =   5415
      Begin VB.PictureBox picDisp 
         Appearance      =   0  'Flat
         AutoRedraw      =   -1  'True
         BackColor       =   &H00FFFFFF&
         ForeColor       =   &H80000008&
         Height          =   4620
         Left            =   270
         ScaleHeight     =   322
         ScaleMode       =   0  'User
         ScaleWidth      =   320
         TabIndex        =   1
         Top             =   480
         Width           =   4830
      End
   End
   Begin VB.Label lblBitCount 
      Alignment       =   2  'Center
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "lblBitCount"
      ForeColor       =   &H80000008&
      Height          =   285
      Left            =   2130
      TabIndex        =   10
      Top             =   6840
      Width           =   1245
   End
   Begin VB.Label lblIconSize 
      Alignment       =   2  'Center
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "lblIconSize"
      ForeColor       =   &H80000008&
      Height          =   285
      Left            =   750
      TabIndex        =   9
      Top             =   6840
      Width           =   1245
   End
   Begin VB.Label lblMask 
      BackColor       =   &H00E0E0E0&
      Height          =   810
      Left            =   2520
      TabIndex        =   7
      Top             =   90
      Width           =   810
   End
   Begin VB.Label lblIcon 
      BackColor       =   &H00E0E0E0&
      Height          =   810
      Left            =   3780
      TabIndex        =   4
      Top             =   90
      Width           =   810
   End
   Begin VB.Label lblFileSpec 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "lblFileSpec"
      ForeColor       =   &H80000008&
      Height          =   285
      Left            =   120
      TabIndex        =   2
      Top             =   7380
      Width           =   6915
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileOpen 
         Caption         =   "&Open (32x32 or 16x16)"
      End
      Begin VB.Menu mnuFilesep1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuHelpNote 
         Caption         =   "&Notes"
      End
   End
End
Attribute VB_Name = "frmLoadIcon32Bit"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' LoadIcon32Bit.frm
'
' By Herman Liu

Option Explicit

Private Declare Function GetShortPathName Lib "kernel32" Alias "GetShortPathNameA" _
   (ByVal lpszLongPath As String, ByVal lpszShortPath As String, _
   ByVal cchBuffer As Long) As Long
   
Private Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" _
    (ByVal hwnd As Long, ByVal lpOperation As String, ByVal lpFile As String, _
    ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long
Const SW_SHOW = 5

Private Declare Function GetPixel Lib "gdi32" (ByVal hDC As Long, ByVal x As Long, _
    ByVal y As Long) As Long
    
Private Declare Function SetPixelV Lib "gdi32" (ByVal hDC As Long, ByVal x As Long, _
    ByVal y As Long, ByVal crColor As Long) As Long

Private Declare Function BitBlt Lib "gdi32" (ByVal hDestDC As Long, ByVal x As Long, _
    ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, _
    ByVal xSrc As Long, ByVal ySrc As Long, ByVal dwRop As Long) As Long
    
Private Declare Function StretchBlt Lib "gdi32" (ByVal hDC As Long, ByVal x As Long, _
    ByVal y As Long, ByVal mDestWidth As Long, ByVal mDestHeight As Long, _
    ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal mSrcWidth As Long, _
    ByVal mSrcHeight As Long, ByVal dwRop As Long) As Long
    
Private Type RGBQUAD
    b As Byte
    g As Byte
    r As Byte
    a As Byte
End Type

Private Type ICONDIR
   idReserved As Integer        ' Reserved
   idType As Integer            ' resource type (1 for icons)
   idCount As Integer           ' how many images?
End Type

Private Type ICONDIRENTRY
   bWidth As Byte               ' Width of the image
   bHeight As Byte              ' Height of the image (times 2)
   bColorCount As Byte          ' Number of colors in image (0 if >=8bpp)
   bReserved As Byte            ' Reserved
   wPlanes As Integer           ' Color Planes
   wBitCount As Integer         ' Bits per pixel
   dwBytesInRes As Long         ' how many bytes in this resource?
   dwImageOffset As Long        ' where in the file is this image
End Type


Dim arrPalette() As Long
Dim arrXOR() As Byte
Dim arrAND() As Byte
Dim arrXORTrue() As Long
Dim arrAlpha() As Byte

Dim typID As ICONDIR
Dim arrTypIDE() As ICONDIRENTRY

Const PixelsPerCell = 10

Dim m_FileSpec As String
Dim m_BitCount As Integer
Dim m_Color As Long
Dim m_Cancel As Boolean

Dim cDlg As clsDlg
'--------------------------------



Private Sub Form_Load()
    Dim i
    
    Me.ScaleMode = vbPixels
    PicIcon.ScaleMode = vbPixels
    PicIcon.Width = 32
    PicIcon.Height = 32
    
    picMask.ScaleMode = vbPixels
    picMask.Width = 32
    picMask.Height = 32
    
    picImage.ScaleMode = vbPixels
    picImage.Width = 32
    picImage.Height = 32
    
    picTemp(0).ScaleMode = vbPixels
    picTemp(1).ScaleMode = vbPixels
    
    picDisp.ScaleMode = vbPixels
    picDisp.Width = (picDisp.Width - picDisp.ScaleWidth) + (32 * PixelsPerCell)
    picDisp.Height = (picDisp.Height - picDisp.ScaleHeight) + (32 * PixelsPerCell)
    picDisp.Left = (picDispContainer.Width - picDisp.Width) / 2
    picDisp.Top = (picDispContainer.Height - picDisp.Height) / 2
    
    PicGrid.ScaleMode = vbPixels
    
    lblFileSpec = ""
    lblIconSize = ""
    lblBitCount = ""
    
    Set cDlg = New clsDlg
    Exit Sub
End Sub




Private Sub Form_Activate()
    Dim tmp As String
    tmp = App.Path & "\Sample_32x32x32.ico"
    centerIconDisp
    CreateGrid
    If IsFileThere(tmp) Then
         If ReadIconFileToImage(tmp, 0) = False Then
              picImage.Picture = LoadPicture()
              picMask.Picture = LoadPicture()
              PicIcon.Picture = LoadPicture()
         Else
              lblFileSpec = "  " & tmp
              tmp = CStr(PicIcon.Width)
              lblIconSize = "Size:   " & tmp & " x " & tmp
              lblBitCount = "BPP:   " & CStr(m_BitCount)
              MagnifyIcon
         End If
    End If
    cmdAlpha.Caption = "Show Alpha Effects"
    cmdAlpha.Enabled = (m_BitCount = 32)
    picDisp.SetFocus
End Sub




Private Sub CreateGrid()
     Dim w
     Dim i, j
     
     PicGrid.Cls
     If PicIcon.Width = 16 Then
          w = 16
     Else
          w = 32
     End If
     PicGrid.Width = PicGrid.Width - PicGrid.ScaleWidth + w * PixelsPerCell
     PicGrid.Height = PicGrid.Height - PicGrid.ScaleHeight + w * PixelsPerCell
     
     w = PicGrid.ScaleWidth
     For i = 1 To w - 1
         PicGrid.Line (0, i * PixelsPerCell)-(PicGrid.ScaleWidth - 1, i * PixelsPerCell)
         PicGrid.Line (i * PixelsPerCell, 0)-(i * PixelsPerCell, PicGrid.ScaleHeight - 1)
     Next i
     Exit Sub
End Sub



Private Sub MagnifyIcon()
    Dim w1 As Long, h1 As Long
    Dim w2 As Long, h2 As Long
    picDisp.Picture = LoadPicture()
    picDisp.Width = picDisp.Width - picDisp.ScaleWidth + PicGrid.ScaleWidth
    picDisp.Height = picDisp.Height - picDisp.ScaleHeight + PicGrid.ScaleHeight
    picDisp.Left = Int((picDispContainer.Width - picDisp.Width) / 2) - 1
    picDisp.Top = Int((picDispContainer.Height - picDisp.Height) / 2) - 1
    w1 = PicIcon.ScaleWidth
    h1 = PicIcon.ScaleHeight
    w2 = picDisp.ScaleWidth
    h2 = picDisp.ScaleHeight
    StretchBlt picDisp.hDC, 0, 0, w2, h2, PicIcon.hDC, 0, 0, w1, h1, vbSrcCopy
    DisplayGrid
    picDisp.Picture = picDisp.Image
End Sub



Private Sub DisplayGrid()
    Dim w
    Dim h
    w = picDisp.ScaleWidth
    h = picDisp.ScaleHeight
    BitBlt picDisp.hDC, 0, 0, w, h, PicGrid.hDC, 0, 0, vbSrcAnd
End Sub



Private Sub centerIconDisp()
    PicIcon.Left = lblIcon.Left + (lblIcon.Width - PicIcon.Width) / 2
    PicIcon.Top = lblIcon.Top + (lblIcon.Height - PicIcon.Height) / 2
    picMask.Left = lblMask.Left + (lblMask.Width - picMask.Width) / 2
    picMask.Top = lblMask.Top + (lblMask.Height - picMask.Height) / 2
End Sub




Private Sub Form_Unload(Cancel As Integer)
    Set cDlg = Nothing
    Unload Me
End Sub




Private Sub mnuFileOpen_Click()
    Dim w As String
    m_FileSpec = cDlg.ShowOpen(Me.hwnd, "", "(*.ico)|*.ico")
    If Len(m_FileSpec) = 0 Then
        Exit Sub
    End If
    
    If LoadOpenFileICO(m_FileSpec) = False Then Exit Sub
    
    lblFileSpec = "  " & m_FileSpec
    w = CStr(PicIcon.Width)
    lblIconSize = "Size:   " & w & " x " & w
    If m_BitCount <> 32 Then
         If m_BitCount = 0 Then                           ' Win 95 icons are sloppy
             lblBitCount = "BPP: (Win 95)"
         Else
             lblBitCount = "BPP:   " & CStr(m_BitCount)
         End If
    Else
         lblBitCount = "BPP:   " & CStr(m_BitCount)
    End If
    CreateGrid
    MagnifyIcon
    
    cmdAlpha.Caption = "Show Alpha Effects"
    cmdAlpha.Enabled = (m_BitCount = 32)
    Exit Sub
End Sub



Private Sub mnuFileExit_Click()
    Unload Me
End Sub



Private Function LoadOpenFileICO(inFileSpec As String) As Boolean
    Dim mIndex As Long
    mIndex = ValidIcon(inFileSpec)
    If mIndex < 0 Then
        MsgBox "Invalid icon file or file does not contain 32x32 or 16x16 icon"
        Exit Function
    End If
      
    If ReadIconFileToImage(inFileSpec, mIndex) = False Then
        picImage.Picture = LoadPicture()
        picMask.Picture = LoadPicture()
        PicIcon.Picture = LoadPicture()
        MsgBox inFileSpec & vbCrLf & "Failed to load this file"
        Exit Function
    End If
         
    LoadOpenFileICO = True
End Function




Private Function ValidIcon(inFileSpec As String) As Integer
    Dim iHandle As Integer
    Dim markSize As Integer
    Dim SelectedIndex As Integer
    Dim w As Integer, h As Integer
    Dim i As Integer
     
    On Error GoTo errHandler
    
    iHandle = FreeFile
    Open inFileSpec For Binary Access Read As #iHandle
    
    Get #iHandle, , typID
    
    ReDim arrTypIDE(typID.idCount - 1)
    For i = 0 To typID.idCount - 1
        Get #1, , arrTypIDE(i)
    Next i
    
    If typID.idCount <= 0 Or typID.idType <> 1 Then
         ValidIcon = -1
         Close #iHandle
         Exit Function
    End If
      
    If arrTypIDE(0).bWidth = 0 Or arrTypIDE(0).bHeight = 0 Or _
           arrTypIDE(0).dwBytesInRes <= 0 Or arrTypIDE(0).dwImageOffset <= 0 Then
         ValidIcon = -1
         Close #iHandle
         Exit Function
    End If
    
    If typID.idCount = 1 Then
         w = arrTypIDE(0).bWidth
         h = arrTypIDE(0).bHeight
         If (w <> 16 And w <> 32) Or (h <> 16 And h <> 32) Then
              ValidIcon = -1
              Close #iHandle
              Exit Function
         End If
         ValidIcon = 0
    Else
         markSize = 0
         For i = 0 To (typID.idCount - 1)
              w = arrTypIDE(i).bWidth
              h = arrTypIDE(i).bHeight
              If w = 16 And h = 16 Then
                   If markSize = 0 Then             ' Get one if nothing yet
                        SelectedIndex = i           ' Will remain only if no 32x32
                   End If
              ElseIf w = 32 And h = 32 Then
                   If markSize <> 32 Then           ' Take whatever is 32x32
                        markSize = 32
                        SelectedIndex = i           ' Really selected
                   Else                             ' If size 32x32 and color=256, give top priority
                         If arrTypIDE(i).wBitCount = 32 Then
                              SelectedIndex = i           ' Really selected
                              Exit For
                        End If
                   End If
              End If
         Next i
         
           ' If no 16x16 or 32x32
         If markSize = 0 Then
              ValidIcon = -1
              Close #iHandle
              Exit Function
         End If
         
           ' Note: Even if w<>h, let the calling program handle it
         ValidIcon = SelectedIndex
    End If
    Close #iHandle
    Exit Function
errHandler:
    ValidIcon = -1
End Function




Private Sub MakeIcon()
    Dim w, h
    w = picImage.ScaleWidth
    h = picImage.ScaleHeight
    PicIcon.Picture = LoadPicture()
    PicIcon.Width = w
    PicIcon.Height = h
    BitBlt PicIcon.hDC, 0, 0, PicIcon.ScaleWidth, PicIcon.ScaleHeight, picMask.hDC, 0, 0, vbSrcAnd
    BitBlt PicIcon.hDC, 0, 0, PicIcon.ScaleWidth, PicIcon.ScaleHeight, picImage.hDC, 0, 0, vbSrcInvert
    PicIcon.Picture = PicIcon.Image
    picImage.Picture = picImage.Image
    picMask.Picture = picMask.Image
    centerIconDisp
      ' Prepare for user to click button "Show Alpha Effects"
    If m_BitCount = 32 Then
         picTemp(0).Picture = LoadPicture()
         picTemp(1).Picture = LoadPicture()
         picTemp(0).Width = w:  picTemp(0).Height = h
         picTemp(1).Width = w:  picTemp(1).Height = h
         picTemp(0).Picture = PicIcon.Image
           ' Since there is only a single color at background, pass it as last argument
         applyAlphaImage picTemp(1), PicIcon.BackColor
         picTemp(1).Picture = picTemp(1).Image
    End If
End Sub




' (1) Later Window platforms can use AlphaBlend call, but earlier versions do not have that
' (2) If programmatically blend in in other situations, specific background colors at
'     background positions should be obtained accordingly.
Private Sub applyAlphaImage(picImageDest As PictureBox, inBackColor As Long)
    Dim tmpScreenColor As Long
    Dim mPercentTransp As Integer
    Dim mPicSize
    Dim r As Integer, g As Integer, b As Integer
    Dim r2 As Integer, g2 As Integer, b2 As Integer
    Dim r3 As Integer, g3 As Integer, b3 As Integer
    Dim i, j
    Dim w As Integer, h As Integer

    On Error Resume Next
    If UBound(arrAlpha) <> picMask.ScaleWidth - 1 Then
        Exit Sub
    End If
       
    w = UBound(arrAlpha)
    h = w
    
    tmpScreenColor = inBackColor
    mPicSize = picMask.ScaleWidth
    picImageDest.Line (0, 0)-(mPicSize, mPicSize), tmpScreenColor, BF
    BreakRGB tmpScreenColor, r2, g2, b2
    For i = 0 To w
         For j = 0 To h
              If GetPixel(picMask.hDC, i, j) = &H0 Then
                   mPercentTransp = Int(CInt(arrAlpha(i, j)) / 255 * 100)
                   m_Color = GetPixel(picImage.hDC, i, j)
                   BreakRGB m_Color, r, g, b
                   r3 = Int((((100 - mPercentTransp) * r2) + (mPercentTransp * r)) / 100)
                   g3 = Int((((100 - mPercentTransp) * g2) + (mPercentTransp * g)) / 100)
                   b3 = Int((((100 - mPercentTransp) * b2) + (mPercentTransp * b)) / 100)
                   SetPixelV picImageDest.hDC, i, j, RGB(r3, g3, b3)
              End If
skipIt:
         Next j
    Next i
End Sub




Private Function GetColorBitCount_IDE(ByVal inIndex As Long, ByVal inBPP As Integer) As Long
    Dim vCount As Variant
    Dim mColorCount As Integer
    Dim mBPP As Integer
    mColorCount = arrTypIDE(inIndex).bColorCount
    mBPP = inBPP
      ' When 256-Color or True-Color, mColorCount(i.e. .ColorCount) would be 0
    If mColorCount = 0 And mBPP > 8 Then            ' If mBPP>8, 2^mBPP will exceed 256
           'In line with GetColorBitCount_Image(), signal back "-1" if True Color
         GetColorBitCount_IDE = -1
         Exit Function
    End If
    If mColorCount = 0 Then
          ' Note Carefully: If 256-color palette, Win95 icons may have mColorCount= 0 and
          ' then BPP as 0 (instead of 8), hence below "If mBPP = 0 Then"
         If mBPP = 0 Then
              vCount = 256
         Else
              vCount = 2 ^ mBPP                     ' 2 ^ 8 = 256
         End If
    Else
         vCount = CLng(mColorCount)
         If vCount <> 2 And vCount <> 16 Then       ' Must be due to sloppy coding of orig file
              If vCount > 2 Then
                   vCount = 16
              Else
                   vCount = 2
              End If
         End If
    End If
    If vCount > 256 Then
         vCount = -1
    End If

    GetColorBitCount_IDE = vCount
End Function




' Memo: This function deals with icons within 4-byte boundary only (not those such as 31x31
' or 20x20)
Private Function ReadIconFileToImage(ByVal inFileSpec As String, ByVal inIndex As Long) As Boolean
    Dim tmpRGB As RGBQUAD
    Dim tmpByte As Byte
    Dim bitVal As Byte
    Dim numColors As Long
    Dim mMaskBytesWidth As Integer
    Dim mOffSet
    Dim w As Integer, h As Integer
    Dim mBPP As Integer
    Dim r As Byte, g As Byte, b As Byte
    Dim i, j, k
    
    ReadIconFileToImage = False
    On Error GoTo errHandler

    Open inFileSpec For Binary As #1
    Get #1, , typID
    If typID.idCount <= 0 Or typID.idType <> 1 Then
         Close
         Exit Function
    End If
    If inIndex > (typID.idCount - 1) Then
         Close
         Exit Function
    End If
    ReDim arrTypIDE(typID.idCount - 1)
    For i = 0 To typID.idCount - 1
        Get #1, , arrTypIDE(i)
    Next i

    w = arrTypIDE(inIndex).bWidth
    h = arrTypIDE(inIndex).bHeight

    If (w <> 16 And w <> 32) Or (h <> 16 And h <> 32) Then
         Close
         Exit Function
    ElseIf w <> h Then
         Close
         Exit Function
    End If
    
    picImage.Picture = LoadPicture()
    picMask.Picture = LoadPicture()
    PicIcon.Picture = LoadPicture()
    picImage.Width = w:  picImage.Height = h
    picMask.Width = w:  picMask.Height = h
    PicIcon.Width = w:  PicIcon.Height = h
    
    mBPP = arrTypIDE(inIndex).wBitCount
    numColors = GetColorBitCount_IDE(inIndex, mBPP)
    
      'Move to start of palette bytes in file
    mOffSet = arrTypIDE(inIndex).dwImageOffset + 40 + 1           ' Get starts at 1
   
      ' For mask. Each bytes has 8 bits and each bit governs ...
    mMaskBytesWidth = Int(w / 8)

    If numColors > 0 Then                  ' >0, not true color. If <=0, no palette
        ReDim arrXOR(0 To (w - 1), 0 To (h - 1)) As Byte
        ReDim arrPalette(0 To numColors - 1) As Long
        For i = 0 To numColors - 1
             Get #1, mOffSet, tmpRGB       ' Read 4 bytes as tmpRGB is 4 bytes
             arrPalette(i) = RGB(tmpRGB.r, tmpRGB.g, tmpRGB.b)
             mOffSet = mOffSet + 4         ' Skip above RGBQUAD 4 bytes
        Next i
    Else
        ReDim arrXORTrue(0 To (w - 1), 0 To (h - 1)) As Long
        ReDim arrAlpha(0 To (w - 1), 0 To (h - 1)) As Byte
    End If
    ReDim arrAND(0 To (w - 1), 0 To (h - 1)) As Byte
        
    For j = (h - 1) To 0 Step -1
        Select Case numColors
            Case 2
                  ' For 2-color palette, each byte governs colors of 8 pixels
                For i = 0 To (mMaskBytesWidth - 1)
                    Get #1, mOffSet, tmpByte
                    mOffSet = mOffSet + 1
                    For k = 0 To 7
                         arrXOR(8 * i + k, j) = BreakMonoByte(tmpByte, k)
                    Next k
                Next i
            Case 16
                   ' For 16-color palette, the bitmap has a maximum of 16 solid colors.
                   ' Each pixel in the bitmap is represented by a 4-bit index into the
                   ' color table, e.g. if the first byte in the bitmap is 0x1F, the byte
                   ' represents two pixels.
                For i = 0 To w - 1 Step 2
                    Get #1, mOffSet, tmpByte
                    mOffSet = mOffSet + 1
                    arrXOR(i, j) = (tmpByte And &HF0&) \ 16
                    arrXOR(i + 1, j) = tmpByte And &HF&
                Next i
                  
            Case 256
                For i = 0 To (w - 1)
                    Get #1, mOffSet, arrXOR(i, j)
                    mOffSet = mOffSet + 1
                Next i
                  
            Case Else
                For i = 0 To (w - 1)
                    Get #1, mOffSet, b
                    Get #1, mOffSet + 1, g
                    Get #1, mOffSet + 2, r
                    arrXORTrue(i, j) = RGB(r, g, b)
                    If mBPP = 24 Then
                         mOffSet = mOffSet + 3
                    Else
                         Get #1, mOffSet + 3, tmpByte
                         If tmpByte > 0 Then
                              arrAlpha(i, j) = tmpByte
                         End If
                         mOffSet = mOffSet + 4
                    End If
                Next i
        End Select
    Next j
    For j = (h - 1) To 0 Step -1
        For i = 0 To (mMaskBytesWidth - 1)
            Get #1, mOffSet, tmpByte
            mOffSet = mOffSet + 1
            For k = 0 To 7
                 arrAND(8 * i + k, j) = BreakMonoByte(tmpByte, k)
            Next k
        Next i
    Next j
    Close
    m_BitCount = mBPP
    If numColors > 0 Then
        PostToImagePerPalette w, h, picImage
    Else
        PostToImageTrueColor w, h, picImage
    End If
    PostToMask w, h, picMask
    MakeIcon
    ReadIconFileToImage = True
    Exit Function
errHandler:
    Close
End Function




Private Sub PostToImagePerPalette(ByVal inW As Integer, ByVal inH As Integer, inPic As PictureBox)
    Dim mRef As Byte
    Dim x, y
    Dim w As Integer, h As Integer
    w = inW - 1
    h = inH - 1
    For y = 0 To h
         For x = 0 To w
              mRef = arrXOR(x, y)
              m_Color = arrPalette(mRef)
              SetPixelV inPic.hDC, x, y, m_Color
         Next x
    Next y
End Sub




Private Sub PostToImageTrueColor(ByVal inW As Integer, ByVal inH As Integer, inPic As PictureBox)
    Dim x, y
    Dim w As Integer, h As Integer
    w = inW - 1
    h = inH - 1
    For y = 0 To h
         For x = 0 To w
              m_Color = arrXORTrue(x, y)
              If m_Color >= 0 Then
                   SetPixelV inPic.hDC, x, y, m_Color
              End If
         Next x
    Next y
End Sub




Private Sub PostToMask(ByVal inW As Integer, ByVal inH As Integer, inPic As PictureBox)
    Dim bitVal As Byte
    Dim x, y
    Dim w As Integer, h As Integer
    w = inW - 1
    h = inH - 1
    For y = 0 To h
         For x = 0 To w
              bitVal = arrAND(x, y)
              If bitVal = 0 Then
                  m_Color = &H0
              Else
                  m_Color = &HFFFFFF
              End If
              SetPixelV inPic.hDC, x, y, m_Color
         Next x
    Next y
End Sub



Private Function BreakMonoByte(ByVal inByte As Byte, ByVal inBitPos As Integer) As Byte
    Dim i
    i = inByte And (2 ^ (7 - inBitPos))
    If i <> 0 Then
         BreakMonoByte = 1
    Else
         BreakMonoByte = 0
    End If
End Function



Private Sub cmdAlpha_Click()
    If cmdAlpha.Caption = "Show Alpha Effects" Then
         cmdAlpha.Caption = "Show Editing Screen"
         PicIcon.Picture = picTemp(1).Image
    Else
         cmdAlpha.Caption = "Show Alpha Effects"
         PicIcon.Picture = picTemp(0).Image
    End If
    MagnifyIcon
End Sub



Private Sub mnuHelpNote_Click()
    If Not IsFileThere(App.Path & "\Notes.htm") Then
         MsgBox "Notes.htm file missing."
         Exit Sub
    End If
    Dim mURL As String
    mURL = App.Path & "\Notes.htm"
    ShellExecute hwnd, "open", mURL, vbNullString, vbNullString, SW_SHOW
End Sub


     
     
Private Function IsFileThere(inFileSpec As String) As Boolean
    On Error Resume Next
    Dim i
    Dim mFile As String
    mFile = LongToShort(inFileSpec)
    i = FreeFile
    Open inFileSpec For Input As i
    If Err Then
        IsFileThere = False
    Else
        IsFileThere = True
    End If
    Close i
End Function




Private Function LongToShort(inSpec) As String
    Dim i
    Dim ShortSpec As String
    Dim mBuffer As String
    Dim mBufLen As Long
    mBufLen = 164
    mBuffer = String(mBufLen, 0)
    i = GetShortPathName(inSpec, mBuffer, mBufLen)
    LongToShort = Left(mBuffer, i)
End Function




Private Sub BreakRGB(ByVal inColor As Long, ByRef inRed, ByRef inGreen, ByRef inBlue)
    inRed = inColor Mod &H100
    inGreen = (inColor \ &H100) Mod &H100
    inBlue = (inColor \ &H10000) Mod &H100
    If inRed > 255 Then inRed = 255
    If inGreen > 255 Then inGreen = 255
    If inBlue > 255 Then inBlue = 255
    If inRed < 0 Then inRed = 0
    If inGreen < 0 Then inGreen = 0
    If inBlue < 0 Then inBlue = 0
End Sub
